#ifndef SGEVENT_H
#define SGEVENT_H

#include <stdio.h>
#include "liste.h"
#include "event.h"

#define g_SGEvent SGEvent::getSGEvent()

class SGEvent
{
    private:
        ListeChainee<Event>  *m_pListeEvent;
        static SGEvent *m_pSGEvent;
        
        
    public:
        SGEvent();
        ~SGEvent();
        
        static SGEvent &getSGEvent() { return *m_pSGEvent ; }
        void add(Event* event, char * szNom) { m_pListeEvent->add(event,szNom); }
        Event *get(const int iRang) { return m_pListeEvent->get( iRang ) ; }
        Event *get(char *szNom) { return m_pListeEvent->get( szNom ) ; }
        void testEvents();
        void supprimer(char *szNom) { m_pListeEvent->del( szNom ) ; }        
        int getSizeListe() { return m_pListeEvent->getSize() ; }
        void debut() { m_pListeEvent->debut(); }
        bool suivant() { return m_pListeEvent->suivant(); }
        Event * getCourant() { return m_pListeEvent->getCourant() ; }
        char * getNomCourant() { return m_pListeEvent->getNom() ; }
        void del(char *szNom){m_pListeEvent->del( szNom );}
        void del(const int iRang){m_pListeEvent->del( iRang );}
        
        bool toujours() { return true ;}
};

#endif

